cd "$master"
clear
use input\sp_raw.dta, clear

* 0. sp detection *
encode detection, gen(detection_code)
gen confirmed_possible_detection= detection_code
recode confirmed_possible_detection 2=0 3=0 4=1 5=0

* 1. create antibiotics outcome * 

gen any_abx=0
replace any_abx=1 if abx_pres1==1 | abx_pres2==1 | abx_pres3==1 | abx_inj1==1 | abx_inj2==1 | abx1==1 | abx2==1 | abx3==1 | abx4==1 | abx5==1 |  abx6==1 
egen total_abx= rsum(abx_pres1 abx_pres2 abx_pres3 abx_inj1 abx_inj2 abx1 abx2 abx3 abx4 abx5  abx6 )

* 2. create correct management outcome

** tb***

gen tb_correct =.
replace tb_correct=1 if tb_outcome=="referral" | tb_outcome=="sputum test" | tb_outcome=="sputum test + referral"  | tb_outcome=="sputum test + xray" | tb_outcome=="sputum test + referral" | tb_outcome=="sputum test + xray + referral" | tb_outcome=="xray + referral" | tb_outcome=="xray"
replace tb_correct=0 if tb_correct==. & spcase==3

** urti** 

gen urti_correct=.
replace urti_correct=0 if spcase==4 & any_abx==1
replace urti_correct=1 if spcase==4 & any_abx==0

** malaria**

gen any_antimalarial=0

foreach i of num 1/6 {
replace any_antimalarial=1 if bnf_class`i'=="antimalarial"
}
foreach i of num 1/3 {
replace any_antimalarial=1 if bnf_class_pres`i'=="antimalarial"
}
foreach i of num 1/2 {
replace any_antimalarial=1 if bnf_class_inj`i'=="antimalarial"
}


encode malaria_result, gen(mal_test_result)

gen malaria_correct_strict=.
replace malaria_correct_strict=0 if spcase==2 
replace malaria_correct_strict=1 if spcase==2 & any_antimalarial==0 & mal_test_result==1

** asthma**

gen any_antiasthmatic=0

foreach i of num 1/6 {
replace any_antiasthmatic=1 if bnf_class`i'=="corticosteroid" | bnf_class`i'=="xanthine" | bnf_class`i'=="xanthine" | bnf_class`i'=="selective beta2-agonist (short-acting)" | bnf_class`i'=="cortosteroid/sedating antihistamine combination" | bnf_class`i'=="vasoconstrictor sympathomimetics/xanthine"    | bnf_class`i'=="selective beta2-agonist (short-acting)/corticosteroid"

}
foreach i of num 1/3 {
replace any_antiasthmatic=1 if bnf_class_pres`i'=="corticosteroid" | bnf_class_pres`i'=="xanthine" | bnf_class_pres`i'=="xanthine" | bnf_class_pres`i'=="selective beta2-agonist (short-acting)" | bnf_class_pres`i'=="cortosteroid/sedating antihistamine combination" | bnf_class_pres`i'=="vasoconstrictor sympathomimetics/xanthine"    | bnf_class_pres`i'=="selective beta2-agonist (short-acting)/corticosteroid"
}
foreach i of num 1/2 {
replace any_antiasthmatic=1 if bnf_class_inj`i'=="corticosteroid" | bnf_class_inj`i'=="xanthine" | bnf_class_inj`i'=="xanthine" | bnf_class_inj`i'=="selective beta2-agonist (short-acting)" | bnf_class_inj`i'=="cortosteroid/sedating antihistamine combination" | bnf_class_inj`i'=="vasoconstrictor sympathomimetics/xanthine"    | bnf_class_inj`i'=="selective beta2-agonist (short-acting)/corticosteroid"
}


gen asthma_correct=.
replace asthma_correct=1 if spcase==1 & any_antiasthmatic==1
replace asthma_correct=0 if spcase==1 & any_antiasthmatic==0

** overall correct_managament***

gen correct_managament=0
replace  correct_managament=1 if asthma_correct==1 | malaria_correct_strict==1 | tb_correct==1 | urti_correct==1 

** exclude xray alone for tb***
gen tb_correct_a=tb_correct
replace tb_correct_a=0 if tb_outcome=="xray"



gen correct_management_a=correct_managament
replace  correct_management_a=0 if tb_correct_a==0

** antiastmatic must be inhaler***

replace asthma_correct=1 if referraldetailreftype==1
replace asthma_correct=. if spcase!=1
replace  correct_management_a=1 if asthma_correct==1 


gen asthma_correct_a=asthma_correct
replace asthma_correct_a=0 if asthma_correct_a==1
replace asthma_correct_a=1 if dispform1==4 | dispform2==4 | dispform3==4 | dispform4==4 

replace  correct_management=1 if asthma_correct==1 
replace  correct_management_a=0 if asthma_correct_a==0


*** specific cases manual correction***
replace asthma_correct=1 if spcase==1 & code==3
replace asthma_correct_a=1 if spcase==1 & code==3
replace correct_management=1 if spcase==1 & code==3
replace correct_management_a=1 if spcase==1 & code==3

replace asthma_correct=1 if spcase==1 & code==125
replace asthma_correct_a=1 if spcase==1 & code==125
replace correct_management=1 if spcase==1 & code==125
replace correct_management_a=1 if spcase==1 & code==125

** generate price variable - fees paid by SP **
gen feestotalfee_corrected=feestotalfee
egen fee_check=rsum (feesconsulfee_corrected feeslabfee_corrected feesmedfee_corrected feesotherfee_corrected )

replace feestotalfee_corrected=fee_check if fee_check!=0 & feestotalfee==0
replace feestotalfee_corrected=fee_check if feestotalfee_corrected!=fee_check & fee_check!=0 & feesconsulfee_corrected!=. & feeslabfee_corrected!=. & feesmedfee_corrected!=. & feesotherfee_corrected!=.
drop fee_check

* 3. create any unnecessary care outcome *

label define overprov_drug 0 "undefined" 1 "correct drug" 2 "palliative drug" 3 "unnecessary drug" 4 "harmful drug"
gen overprov_drug1=bnfcode1
recode overprov_drug1 1/99=0
label values overprov_drug1 overprov_drug  

forvalues i=2/6 {
gen overprov_drug`i'=bnfcode`i'
recode overprov_drug`i' 1/99=0
label values overprov_drug`i' overprov_drug  
}


// HARMFUL FOR EVRYTHING
forvalues i=1/6 {
replace overprov_drug`i' = 4 if bnfcode`i'==29 //opiods to harmful
replace overprov_drug`i' = 4 if bnfcode`i'==9 // benzos to harmful
}
// SPECIFIC HARMS

forvalues i=1/6 {
replace overprov_drug`i' = 4 if bnfcode`i'==27 & spcase==1 //NSAIDs to harmful for asthma case
replace overprov_drug`i' = 4 if bnfcode`i'==28 & spcase==1 // NSAID combos to harmful for asthma case
}
forvalues i=1/6 {
replace overprov_drug`i' = 4 if bnfcode`i'==14 & spcase==3 //steroids to harmful for TB case
replace overprov_drug`i' = 4 if bnfcode`i'==15 & spcase==3 // steroid combos to harmful for TB case
}


forvalues i=1/6 {
gen flouro`i'=0 if abx`i'==1
}
forvalues i=1/6 {
recode flouro`i' 0=1 if drugname`i'==31
recode flouro`i' 0=1 if drugname`i'==56
recode flouro`i' 0=1 if drugname`i'==67
recode flouro`i' 0=1 if drugname`i'==70
recode flouro`i' 0=1 if drugname`i'==68
}

forvalues i=1/6 {
replace overprov_drug`i' = 4 if flouro`i'==1 & spcase==3 //flouroquinolones to harmful for TB case
}

// ASTHMA

forvalues i=1/6 {
recode overprov_drug`i' 0= 2 if bnfcode`i'==39 & spcase==1 //  other selective beta2-agonist to palliative for asthma
recode overprov_drug`i' 0= 2 if bnfcode`i'==40 & spcase==1 //  other selective beta2-agonist to palliative for asthma
recode overprov_drug`i' 0= 2 if bnfcode`i'==14 & spcase==1 //  steroid to palliative for asthma
recode overprov_drug`i' 0= 2 if bnfcode`i'==15 & spcase==1 //  steroid combo  to palliative for asthma
recode overprov_drug`i' 0= 2 if bnfcode`i'==46 & spcase==1 //   vasoconstrictor sympathomimetics/xanthine to palliative for asthma
recode overprov_drug`i' 0= 2 if bnfcode`i'==47 & spcase==1 //  xanthine to palliative for asthma
recode overprov_drug`i' 0= 2 if bnfcode`i'==25 & spcase==1 //   non sedating antihist to palliative for asthma
recode overprov_drug`i' 0= 2 if bnfcode`i'==37 & spcase==1 //  sedating antihist to palliative for asthma

}


// some editing by hand for cold and flu combos dep on ingredients for asthma case 

replace overprov_drug2 = 4 in 204
replace overprov_drug2 = 2 in 886


forvalues i=1/6 {
recode overprov_drug`i' 0= 3 if bnfcode`i'==2 & spcase==1 //  ace inhibitor to unnecessary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==5 & spcase==1 //  anthelmintic to unnecessary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==6 & spcase==1 //  antimalarial to unnecesaary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==11 & spcase==1 //   broad-spectrum penicillin  to unnecesaary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==12 & spcase==1 //   calcium-channel blocker to unnecesaaryr for asthma

recode overprov_drug`i' 0= 3 if bnfcode`i'==16 & spcase==1 //  expectorant to unnecesaary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==18 & spcase==1 //   first-generation cephalosporin unnecessary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==21 & spcase==1 //  loop diuretic unnecessary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==22 & spcase==1 //  mCROLIDEto unnecessary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==23 & spcase==1 //  nitroimidazole derivative to unnecessary for asthma

recode overprov_drug`i' 0= 3 if bnfcode`i'==24 & spcase==1 //  paracet to unnecesaary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==26 & spcase==1 //   non-therapeutic  to unnecesaary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==30 & spcase==1 //   ORS to unnecesaaryr for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==31 & spcase==1 //  other antibacterial to unnecesaary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==32 & spcase==1 //   pencillin combo unnecessary for asthma

recode overprov_drug`i' 0= 3 if bnfcode`i'==34 & spcase==1 //  proton pump inhib unnecessary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==35 & spcase==1 //   quinolone  to unnecesaary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==41 & spcase==1 //   statin to unnecesaaryr for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==38 & spcase==1 //  selective beta blocking agent  to unnecesaary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==4 & spcase==1 //   angiotensin ii receptor antagonist unnecessary for asthma


recode overprov_drug`i' 0= 3 if bnfcode`i'==10 & spcase==1 //  beta-lactamase sensitive penicillin unnecessary for asthma
recode overprov_drug`i' 0= 3 if bnfcode`i'==36 & spcase==1 //  quinolone/nitromidazole combination   to unnecesaary for asthma


}


// MALARIA



forvalues i=1/6 {
recode overprov_drug`i' 0= 2 if drugname`i'==49 & spcase==2 //  herbal cough syrups to palliative for malaria
recode overprov_drug`i' 0= 3 if drugname`i'==86 & spcase==2 // vitamins to unnec for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==6 & spcase==2 //  antimalarial to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==5 & spcase==2 //  anthelmintic to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==11 & spcase==2 //  broad-spectrum penicillin to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==14 & spcase==2 //  steroid to unnecesaary  for malaria
recode overprov_drug`i' 0= 2 if bnfcode`i'==16 & spcase==2 //   expectorant  to palliative  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==17 & spcase==2 //  first-generation cephalosporin to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==18 & spcase==2 //  first-generation cephalosporin to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==22 & spcase==2 //  macrolide to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==23 & spcase==2 //  nitroimidazole derivative to unnecesaary  for malaria
recode overprov_drug`i' 0= 2 if bnfcode`i'==24 & spcase==2 //   paracet  to palliative  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==25 & spcase==2 // non sed antihist to unnecesaary  for malaria
recode overprov_drug`i' 0= 2 if bnfcode`i'==27 & spcase==2 //   NSAIDs  to palliative  for malaria
recode overprov_drug`i' 0= 2 if bnfcode`i'==28 & spcase==2 //   NSAID combos  to palliative  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==30 & spcase==2 // ORS to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==31 & spcase==2 // other antibact to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==32 & spcase==2 // pencillin combo to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==35 & spcase==2 // quinolones to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==37 & spcase==2 // sedating antihisat to unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==42 & spcase==2 // tetracyclineto unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if bnfcode`i'==43 & spcase==2 // thiazides  unnecesaary  for malaria
recode overprov_drug`i' 0= 3 if drugname`i'==59 & spcase==2  // magnesium unnec
}

// TB 


forvalues i=1/6 {
recode overprov_drug`i' 0= 2 if drugname`i'==49 & spcase==3 //  herbal cough syrups to palliative for TB
recode overprov_drug`i' 0= 3 if drugname`i'==86 & spcase==3 // vitamins to unnec for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==6 & spcase==3 //  antimalarial to unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==5 & spcase==3 //  anthelmintic to unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==7 & spcase==3 //  antimuscarinic  to unnecesaary  for TB

recode overprov_drug`i' 0= 3 if bnfcode`i'==10 & spcase==3 //   beta-lactamase sensitiveto unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==11 & spcase==3 //  broad-spectrum penicillin to unnecesaary  for TB
recode overprov_drug`i' 0= 2 if bnfcode`i'==13 & spcase==3 //   cold flu combos  to palliative  for TB


recode overprov_drug`i' 0= 2 if bnfcode`i'==16 & spcase==3 //   expectorant  to palliative  for TB

recode overprov_drug`i' 0= 3 if bnfcode`i'==17 & spcase==3 //  first-generation cephalosporin to unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==18 & spcase==3 //  first-generation cephalosporin to unnecesaary  for TB

recode overprov_drug`i' 0= 3 if bnfcode`i'==22 & spcase==3 //  macrolide to unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==23 & spcase==3 //  nitroimidazole derivative to unnecesaary  for TB

recode overprov_drug`i' 0= 2 if bnfcode`i'==24 & spcase==3 //   paracet  to palliative  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==25 & spcase==3 // non sed antihist to unnecesaary  for TB
recode overprov_drug`i' 0= 2 if bnfcode`i'==27 & spcase==3 //   NSAIDs  to palliative  for TB
recode overprov_drug`i' 0= 2 if bnfcode`i'==28 & spcase==3 //   NSAID combos  to palliative  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==30 & spcase==3 // ORS to unnecesaary  for TB

recode overprov_drug`i' 0= 3 if bnfcode`i'==31 & spcase==3 // other antibact to unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==32 & spcase==3 // pencillin combo to unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==33 & spcase==3 // polyene antifungal to unnecesaary  for TB

recode overprov_drug`i' 0= 3 if bnfcode`i'==37 & spcase==3 // sedating antihisat to unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==39 & spcase==3 // selecting beta 2 antoginst  to unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==42 & spcase==3 // tetracyclineto unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==43 & spcase==3 // thiazides  unnecesaary  for TB
recode overprov_drug`i' 0= 3 if bnfcode`i'==47 & spcase==3 // xanthines  unnecesaary  for TB

}

// URTI


forvalues i=1/6 {
recode overprov_drug`i' 0= 2 if drugname`i'==49 & spcase==4 //  herbal cough syrups to palliative 
recode overprov_drug`i' 0= 3 if drugname`i'==86 & spcase==4 // vitamins to unnec 
recode overprov_drug`i' 0= 3 if bnfcode`i'==6 & spcase==4 //  antimalarial to unnecesaary 
recode overprov_drug`i' 0= 3 if bnfcode`i'==5 & spcase==4 //  anthelmintic to unnecesaary  
recode overprov_drug`i' 0= 3 if bnfcode`i'==11 & spcase==4 //  broad-spectrum penicillin to unnecesaary 
recode overprov_drug`i' 0= 3 if bnfcode`i'==14 & spcase==4 //  steroid to unnecesaary 
recode overprov_drug`i' 0= 2 if bnfcode`i'==16 & spcase==4 //   expectorant  to palliative  
recode overprov_drug`i' 0= 3 if bnfcode`i'==17 & spcase==4 //  first-generation cephalosporin to unnecesaary 
recode overprov_drug`i' 0= 3 if bnfcode`i'==18 & spcase==4 //  first-generation cephalosporin to unnecesaary  f
recode overprov_drug`i' 0= 3 if bnfcode`i'==22 & spcase==4 //  macrolide to unnecesaary  
recode overprov_drug`i' 0= 3 if bnfcode`i'==23 & spcase==4 //  nitroimidazole derivative to unnecesaary  
recode overprov_drug`i' 0= 2 if bnfcode`i'==24 & spcase==4 //   paracet  to palliative 
recode overprov_drug`i' 0= 3 if bnfcode`i'==25 & spcase==4 // non sed antihist to unnecesaary  
recode overprov_drug`i' 0= 2 if bnfcode`i'==27 & spcase==4 //   NSAIDs  to palliative  
recode overprov_drug`i' 0= 2 if bnfcode`i'==28 & spcase==4 //   NSAID combos  to palliative  
recode overprov_drug`i' 0= 3 if bnfcode`i'==30 & spcase==4 // ORS to unnecesaary  f
recode overprov_drug`i' 0= 3 if bnfcode`i'==31 & spcase==4 // other antibact to unnecesaary  
recode overprov_drug`i' 0= 3 if bnfcode`i'==32 & spcase==4 // pencillin combo to unnecesaary  
recode overprov_drug`i' 0= 3 if bnfcode`i'==35 & spcase==4 // quinolones to unnecesaary  
recode overprov_drug`i' 0= 3 if bnfcode`i'==37 & spcase==4 // sedating antihisat to unnecesaary
recode overprov_drug`i' 0= 3 if bnfcode`i'==42 & spcase==4 // tetracyclineto unnecesaary  
recode overprov_drug`i' 0= 3 if bnfcode`i'==43 & spcase==4 // thiazides  unnecesaary  
recode overprov_drug`i' 0= 3 if drugname`i'==59 & spcase==4  // magnesium unnec
}

forvalues i=1/6 {
recode overprov_drug`i' 0= 3 if bnfcode`i'==10 & spcase==4 //  
recode overprov_drug`i' 0= 3 if bnfcode`i'==44 & spcase==4 //
recode overprov_drug`i' 0= 3 if bnfcode`i'==8 & spcase==4 //  
recode overprov_drug`i' 0= 3 if bnfcode`i'==36 & spcase==4 //  
recode overprov_drug`i' 0= 3 if bnfcode`i'==20 & spcase==4 //  
recode overprov_drug`i' 0= 3 if bnfcode`i'==19 & spcase==4 //  
recode overprov_drug`i' 0= 3 if bnfcode`i'==39 & spcase==4 //  
recode overprov_drug`i' 0= 2 if bnfcode`i'==13 & spcase==4 //

}



*** now prescribed not dispensed ***


forvalues i=1/3 {
gen overprov_drug_pres`i'=bnfprescode`i'
recode overprov_drug_pres`i' 1/99=0
label values overprov_drug_pres`i' overprov_drug  
}


// HARMFUL FOR EVRYTHING
forvalues i=1/3 {
replace overprov_drug_pres`i' = 4 if bnfprescode`i'==29 //opiods to harmful
replace overprov_drug_pres`i' = 4 if bnfprescode`i'==9 // benzos to harmful
}
// SPECIFIC HARMS

forvalues i=1/3 {
replace overprov_drug_pres`i' = 4 if bnfprescode`i'==27 & spcase==1 //NSAIDs to harmful for asthma case
replace overprov_drug_pres`i' = 4 if bnfprescode`i'==28 & spcase==1 // NSAID combos to harmful for asthma case
}
forvalues i=1/3 {
replace overprov_drug_pres`i' = 4 if bnfprescode`i'==14 & spcase==3 //steroids to harmful for TB case
replace overprov_drug_pres`i' = 4 if bnfprescode`i'==15 & spcase==3 // steroid combos to harmful for TB case
}



forvalues i=1/3 {
gen flouro_pres`i'=0 if abx_pres`i'==1
}
forvalues i=1/3 {
recode flouro_pres`i' 0=1 if drug_pres`i'==31
recode flouro_pres`i' 0=1 if drug_pres`i'==56
recode flouro_pres`i' 0=1 if drug_pres`i'==67
recode flouro_pres`i' 0=1 if drug_pres`i'==70
recode flouro_pres`i' 0=1 if drug_pres`i'==68
}

forvalues i=1/3 {
replace overprov_drug_pres`i' = 4 if flouro_pres`i'==1 & spcase==3 //flouroquinolones to harmful for TB case
}

// ASTHMA

forvalues i=1/3 {
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==39 & spcase==1 //  other selective beta2-agonist to palliative for asthma
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==40 & spcase==1 //  other selective beta2-agonist to palliative for asthma
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==14 & spcase==1 //  steroid to palliative for asthma
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==15 & spcase==1 //  steroid combo  to palliative for asthma
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==46 & spcase==1 //   vasoconstrictor sympathomimetics/xanthine to palliative for asthma
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==47 & spcase==1 //  xanthine to palliative for asthma
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==25 & spcase==1 //   non sedating antihist to palliative for asthma
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==37 & spcase==1 //  sedating antihist to palliative for asthma

}





forvalues i=1/3{

recode overprov_drug_pres`i' 0= 4 if bnfprescode`i'==1 & spcase==1 //   nsaids to harmful for asthma

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==16 & spcase==1 //  expectorant to unnecesaary for asthma


}


// MALARIA




forvalues i=1/3 {

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==6 & spcase==2 //  antimalarial to unnecesaary  for malaria

recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==24 & spcase==2 //   paracet  to palliative  for malaria
recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==25 & spcase==2 // non sed antihist to unnecesaary  for malaria
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==1 & spcase==2 //   NSAIDs  to palliative  for malaria

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==35 & spcase==2 // quinolones to unnecesaary  for malaria

}

// TB 


forvalues i=1/3 {

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==5 & spcase==3 //  anthelmintic to unnecesaary  for TB

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==11 & spcase==3 //  broad-spectrum penicillin to unnecesaary  for TB
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==13 & spcase==3 //   cold flu combos  to palliative  for TB


recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==16 & spcase==3 //   expectorant  to palliative  for TB


recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==22 & spcase==3 //  macrolide to unnecesaary  for TB

recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==24 & spcase==3 //   paracet  to palliative  for TB
recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==25 & spcase==3 // non sed antihist to unnecesaary  for TB

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==32 & spcase==3 // pencillin combo to unnecesaary  for TB

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==39 & spcase==3 // selecting beta 2 antoginst  to unnecesaary  for TB


}


// URTI


forvalues i=1/3 {

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==11 & spcase==4 //  broad-spectrum penicillin to unnecesaary  for urti

recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==16 & spcase==4 //   expectorant  to palliative  for urti

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==37 & spcase==4 // sedating antihisat to unnecesaary  for urti

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==25 & spcase==4 //   non-sedating antihistamine   to unnecesaary  for urti

recode overprov_drug_pres`i' 0= 3 if bnfprescode`i'==32 & spcase==4 // pencillin combo unnecesaary  for urti
recode overprov_drug_pres`i' 0= 2 if bnfprescode`i'==24 & spcase==4 //   paracet  to palliative  for urti


}
*** now injections ****
forvalues i=1/2 {
gen overprov_inj`i'=bnfinjcode`i'
recode overprov_inj`i' 1/99=0
label values overprov_inj`i' overprov_drug  
}


// HARMFUL FOR EVRYTHING
forvalues i=1/2 {
replace overprov_inj`i' = 4 if bnfinjcode`i'==29 //opiods to harmful
replace overprov_inj`i' = 4 if bnfinjcode`i'==9 // benzos to harmful
}
// SPECIFIC HARMS

forvalues i=1/2 {
replace overprov_inj`i' = 4 if bnfinjcode`i'==1 & spcase==1 //NSAIDs to harmful for asthma case
replace overprov_inj`i' = 4 if bnfinjcode`i'==27 & spcase==1 //NSAIDs to harmful for asthma case
replace overprov_inj`i' = 4 if bnfinjcode`i'==28 & spcase==1 // NSAID combos to harmful for asthma case
}
forvalues i=1/2 {
replace overprov_inj`i' = 4 if bnfinjcode`i'==14 & spcase==3 //steroids to harmful for TB case
replace overprov_inj`i' = 4 if bnfinjcode`i'==15 & spcase==3 // steroid combos to harmful for TB case
}



forvalues i=1/2 {
gen flouro_inj`i'=0 if abx_inj`i'==1
}
forvalues i=1/2 {
recode flouro_inj`i' 0=1 if injection`i'==31
recode flouro_inj`i' 0=1 if injection`i'==56
recode flouro_inj`i' 0=1 if injection`i'==67
recode flouro_inj`i' 0=1 if injection`i'==70
recode flouro_inj`i' 0=1 if injection`i'==68
}

forvalues i=1/3 {
replace overprov_drug_pres`i' = 4 if flouro_pres`i'==1 & spcase==3 //flouroquinolones to harmful for TB case
}



// ASTHMA

forvalues i=1/2 {
recode overprov_inj`i' 0= 3 if bnfinjcode`i'==10 & spcase==1 //  penicillin to unnec for asthma

recode overprov_inj`i' 0= 2 if bnfinjcode`i'==14 & spcase==1 //  steroid to palliative for asthma

recode overprov_inj`i' 0= 2 if bnfinjcode`i'==47 & spcase==1 //  xanthine to palliative for asthma


}


// MALARIA


forvalues i=1/2 {

recode overprov_inj`i' 0= 3 if bnfinjcode`i'==6 & spcase==2 //  antimalarial to unnecesaary  for malaria

recode overprov_inj`i' 0= 3 if bnfinjcode`i'==3 & spcase==2 //   aminoglycosides to unn for malaria

}


// TB 


forvalues i=1/2 {

recode overprov_inj`i' 0= 3 if bnfinjcode`i'==3 & spcase==3 //  aminoglycosides to unnecesaary  for TB
recode overprov_inj`i' 0= 3 if bnfinjcode`i'==10 & spcase==3 //  beta l s penicillin to unnecesaary  for TB
recode overprov_inj`i' 0= 3 if bnfinjcode`i'==18 & spcase==3 //    first-generation cephalosporin  to unnecesaary  for TB


}


// URTI


forvalues i=1/2 {

recode overprov_inj`i' 0= 2 if bnfinjcode`i'==1 & spcase==4 //  nsaids to palliative  for urti

recode overprov_inj`i' 0= 3 if bnfinjcode`i'==6 & spcase==4 //   antimal to unnec for urti

recode overprov_inj`i' 0= 3 if bnfinjcode`i'==10 & spcase==4 //  beta l s penicillinto unnecesaary  for urti
}


*** tests ****

gen overprov_esr=.
label define overprov_test 0 "undefined" 1 "appropriate" 2 "rarely approproate/unlikely to be appropriate" 3 "inappropriate"
label values overprov_esr overprov_test
recode overprov_esr .=3 if diagnosticsesr==1

gen overprov_fbp=.
label values overprov_fbp overprov_test
recode overprov_fbp .=3 if diagnosticsfbp==1 & spcase==1
recode overprov_fbp .=1 if diagnosticsfbp==1 & spcase==2
recode overprov_fbp .=1 if diagnosticsfbp==1 & spcase==3
recode overprov_fbp .=2 if diagnosticsfbp==1 & spcase==4

gen overprov_mrdt=.
label values overprov_mrdt overprov_test
gen overprov_mbs=.
label values overprov_mbs overprov_test
recode overprov_mrdt .=3 if diagnosticsmrdt==1 & spcase==1
recode overprov_mrdt .=1 if diagnosticsmrdt==1 & spcase==2
recode overprov_mrdt .=1 if diagnosticsmrdt==1 & spcase==3
recode overprov_mrdt .=1 if diagnosticsmrdt==1 & spcase==4
recode overprov_mbs .=3 if diagnosticsmbs==1 & spcase==1
recode overprov_mbs .=1 if diagnosticsmbs==1 & spcase==2
recode overprov_mbs .=1 if diagnosticsmbs==1 & spcase==3
recode overprov_mbs .=1 if diagnosticsmbs==1 & spcase==4

gen overprov_hivrdt=.
label values overprov_hivrdt overprov_test
recode overprov_hivrdt .=1 if diagnosticshivrdt==1 

gen overprov_hb=.
label values overprov_hb overprov_test
recode overprov_hb .=3 if diagnosticshb==1 


gen overprov_glucose=.
label values overprov_glucose overprov_test
recode overprov_glucose .=3 if diagnosticsglucose==1 

gen overprov_afb=.
label values overprov_afb overprov_test
recode overprov_afb .=1 if diagnosticstbafb==1  & spcase==1
recode overprov_afb .=2 if diagnosticstbafb==1  & spcase==2
recode overprov_afb .=1 if diagnosticstbafb==1  & spcase==3
recode overprov_afb .=2 if diagnosticstbafb==1  & spcase==4

gen overprov_xray=.
label values overprov_xray overprov_test
recode overprov_xray .=1 if diagnosticsxray==1  & spcase==1
recode overprov_xray .=3 if diagnosticsxray==1  & spcase==2
recode overprov_xray .=1 if diagnosticsxray==1  & spcase==3
recode overprov_xray .=3 if diagnosticsxray==1  & spcase==4

gen overprov_urin=.
label values overprov_urin overprov_test
recode overprov_urin .=3 if diagnosticsurinalysis==1  & spcase==1
recode overprov_urin .=2 if diagnosticsurinalysis==1  & spcase==2
recode overprov_urin .=3 if diagnosticsurinalysis==1  & spcase==3
recode overprov_urin .=3 if diagnosticsurinalysis==1  & spcase==4

gen overprov_worms=.
label values overprov_worms overprov_test
recode overprov_worms .=3 if diagnosticsworms==1 

gen diagnosticsecg=0
recode diagnosticsecg 0=1 if othertestdetailsothertestspecify=="Allergy test, ECHO" | othertestdetailsothertestspecify== "ECG (Heart)"
gen overprov_ecg=.
label values overprov_ecg overprov_test
recode overprov_ecg .=1 if diagnosticsecg==1  & spcase==1
recode overprov_ecg .=3 if diagnosticsecg==1  & spcase==2
recode overprov_ecg .=3 if diagnosticsecg==1  & spcase==3
recode overprov_ecg .=3 if diagnosticsecg==1  & spcase==4

gen overprov_widal=.
label values overprov_widal overprov_test
recode overprov_widal .=3 if diagnosticswidal==1  & spcase==1
recode overprov_widal .=2 if diagnosticswidal==1  & spcase==2
recode overprov_widal .=1 if diagnosticswidal==1  & spcase==3
recode overprov_widal .=3 if diagnosticswidal==1  & spcase==4


gen diagnosticsallergy=0
recode diagnosticsallergy 0=1 if othertestdetailsothertestspecify=="Allergy test, ECHO" 
gen overprov_allergy=.
label values overprov_allergy overprov_test
recode overprov_allergy .=1 if diagnosticsallergy==1  & spcase==1
recode overprov_allergy .=3 if diagnosticsallergy==1  & spcase==2
recode overprov_allergy .=3 if diagnosticsallergy==1  & spcase==3
recode overprov_allergy .=3 if diagnosticsallergy==1  & spcase==4

gen diagnosticsbruc=0
recode diagnosticsbruc 0=1 if othertestdetailsothertestspecify=="Brucella" | othertestdetailsothertestspecify== "Brucella,H-pilory"
gen overprov_bruc=.
label values overprov_bruc overprov_test
recode overprov_bruc .=3 if diagnosticsbruc==1  

gen diagnosticsvdrl=0
recode diagnosticsvdrl 0=1 if othertestdetailsothertestspecify=="V.D.R.L" | othertestdetailsothertestspecify== "VDRL"
gen overprov_vdrl=.
label values overprov_vdrl overprov_test
recode overprov_vdrl .=3 if diagnosticsvdrl==1  

recode diagnosticsxray 0=1 if othertestdetailsothertestspecify=="X-ray"

gen diagnosticscreatine=0
recode diagnosticscreatine 0=1 if othertestdetailsothertestspecify=="CBC,CREATINE,CHOLESTEROL TOTAL,LDL" 
gen overprov_creatine=.
label values overprov_creatine overprov_test
recode overprov_creatine .=3 if diagnosticscreatine==1 

gen diagnosticschol=0
recode diagnosticschol 0=1 if othertestdetailsothertestspecify=="CBC,CREATINE,CHOLESTEROL TOTAL,LDL" 
gen overprov_chol=.
label values overprov_chol overprov_test
recode overprov_chol .=3 if diagnosticschol==1 

gen diagnosticshpil=0
recode diagnosticshpil 0=1 if othertestdetailsothertestspecify== "Brucella,H-pilory"
gen overprov_hpil=.
label values overprov_hpil overprov_test
recode overprov_hpil .=3 if diagnosticshpil==1  

**** overall**

gen any_unnecessary_care=0

forvalues i=1/6 {

recode any_unnecessary_care 0=1 if overprov_drug`i'==3 | overprov_drug`i'==4 | overprov_drug`i'==0
   
}

forvalues i=1/3 {
	recode any_unnecessary_care 0=1 if overprov_drug_pres`i'==3 | overprov_drug_pres`i'==4 | overprov_drug_pres`i'==0

}
forvalues i=1/2 {
	recode any_unnecessary_care 0=1 if overprov_inj`i'==3 | overprov_inj`i'==4 | overprov_inj`i'==0

}

foreach var of varlist overprov_esr overprov_fbp overprov_mrdt overprov_mbs overprov_hivrdt overprov_hb overprov_glucose overprov_afb overprov_xray overprov_urin overprov_worms overprov_ecg overprov_widal overprov_allergy overprov_bruc overprov_vdrl overprov_creatine overprov_chol overprov_hpil {
	
	recode any_unnecessary_care 0=1 if `var'==2 | `var'==3 |`var'==0
}



** drop all variables not needed for analysis
keep metainstanceid spcase code correct_management_a any_unnecessary_care total_abx feestotalfee_corrected interviewercode confirmed_possible_detection

save output\clean_sp.dta, replace

